//Stepper motor for slider

#define dirPin 2
#define stepPin 3
#define stepsPerRevolution 200
#define LBUTTON 4
#define RBUTTON 5
#define SBUTTON 6

int customDelay, customDelayMapped;
int speedUp() {
int customDelay = analogRead(A0); 
int newCustom = map(customDelay, 0, 1023, 500, 7000); 
return newCustom;
  }

int Lstate=0;
int Rstate=0;

void setup() {
  
  pinMode(stepPin, OUTPUT);
  pinMode(dirPin, OUTPUT);
  pinMode(LBUTTON, INPUT_PULLUP);
  pinMode(RBUTTON, INPUT_PULLUP);
  pinMode(SBUTTON, INPUT_PULLUP);
}

void loop() {

  customDelayMapped = speedUp();

  // STOP BUTTON
  if (digitalRead(SBUTTON) == HIGH) {
  Lstate=0;
  Rstate=0;
  }

  if (Lstate == 0 && Rstate ==0) {
  digitalWrite(dirPin, HIGH);
  digitalWrite(stepPin, LOW);
  delayMicroseconds(customDelayMapped);
  digitalWrite(stepPin, LOW);
  delayMicroseconds(customDelayMapped);
  
    }

  // FORWARD BUTTON
  if (digitalRead(LBUTTON) == LOW) {
  Lstate=1;
  Rstate=0;
  }

  if (Lstate == 1) {
  digitalWrite(dirPin, HIGH);
  digitalWrite(stepPin, HIGH);
  delayMicroseconds(customDelayMapped);
  digitalWrite(stepPin, LOW);
  delayMicroseconds(customDelayMapped);
  
    }
    
  // BACKWARD BUTTON
  if (digitalRead(RBUTTON) == LOW) {
  Lstate=0;
  Rstate=1;
  }

  if (Rstate == 1) {
  digitalWrite(dirPin, LOW);
  digitalWrite(stepPin, HIGH);
  delayMicroseconds(customDelayMapped);
  digitalWrite(stepPin, LOW);
  delayMicroseconds(customDelayMapped);
  
   }
  }
  
 


